# سیستم API - وثائق کامل

## مقدمه
وثائق کامل برای تمام نقاط پایانی API سیستم حسابداری دزکالا

---

## احراز هویت (Authentication)

### ورود
**درخواست:** `POST /api/v1/auth/login`

```json
{
  "email": "user@dezkala.com",
  "password": "password123"
}
```

**پاسخ موفق:**
```json
{
  "success": true,
  "message": "ورود موفق‌آمیز",
  "access_token": "eyJ0eXAiOiJKV1QiLCJhbGc...",
  "token_type": "bearer",
  "expires_in": 3600,
  "user": {
    "id": 1,
    "name": "مهرداد",
    "email": "user@dezkala.com",
    "role": "admin"
  }
}
```

---

## مدیریت موجودی (Inventory)

### دریافت لیست موجودی
**درخواست:** `GET /api/v1/inventory`

**پارامترهای کوئری:**
- `warehouse_id` (optional): فیلتر بر اساس انبار
- `low_stock` (optional): دریافت فقط موجودی پایین (true/false)
- `product_id` (optional): فیلتر بر اساس محصول
- `per_page` (optional): تعداد نتایج در هر صفحه (پیش‌فرض: 15)

**پاسخ:**
```json
{
  "success": true,
  "message": "موجودی‌های دریافت‌شده",
  "data": [
    {
      "id": 1,
      "product_id": 101,
      "warehouse_id": 1,
      "quantity": 50,
      "reorder_level": 10,
      "last_stock_check": "2024-04-15T10:30:00Z",
      "created_at": "2024-01-01T00:00:00Z",
      "updated_at": "2024-04-15T10:30:00Z"
    }
  ],
  "pagination": {
    "current_page": 1,
    "total": 100,
    "per_page": 15,
    "last_page": 7
  }
}
```

### دریافت موجودی پایین
**درخواست:** `GET /api/v1/inventory/low-stock`

**پاسخ:**
```json
{
  "success": true,
  "message": "آیتم‌های موجودی پایین دریافت‌شده",
  "count": 15,
  "data": [...]
}
```

### بروز کردن موجودی
**درخواست:** `PUT /api/v1/inventory/{inventory}`

**بدنه درخواست:**
```json
{
  "quantity": 100,
  "reorder_level": 20
}
```

### خلاصه موجودی
**درخواست:** `GET /api/v1/inventory/summary`

**پاسخ:**
```json
{
  "success": true,
  "message": "خلاصه موجودی",
  "data": [
    {
      "warehouse_id": 1,
      "item_count": 250,
      "total_quantity": 5000
    }
  ]
}
```

### دریافت تاریخچه موجودی
**درخواست:** `GET /api/v1/inventory/{inventory}/movements`

**پارامترهای کوئری:**
- `type` (optional): نوع حرکت (purchase, sale, adjustment, etc.)
- `start_date` (optional): تاریخ شروع
- `end_date` (optional): تاریخ پایان

---

## مدیریت قیمت‌ها (Prices)

### دریافت لیست قیمت‌ها
**درخواست:** `GET /api/v1/prices`

**پارامترهای کوئری:**
- `product_id` (optional): فیلتر بر اساس محصول
- `with_discount` (optional): فقط قیمت‌های با تخفیف

**پاسخ:**
```json
{
  "success": true,
  "message": "قیمت‌ها دریافت‌شده",
  "data": [
    {
      "id": 1,
      "product_id": 101,
      "base_price": 100000,
      "selling_price": 150000,
      "wholesale_price": 120000,
      "discount_percentage": 10,
      "discount_start": "2024-04-01T00:00:00Z",
      "discount_end": "2024-04-30T23:59:59Z",
      "currency": "IRR",
      "effective_date": "2024-04-01T00:00:00Z"
    }
  ]
}
```

### ایجاد قیمت جدید
**درخواست:** `POST /api/v1/prices`

**بدنه درخواست:**
```json
{
  "product_id": 101,
  "base_price": 100000,
  "selling_price": 150000,
  "wholesale_price": 120000,
  "discount_percentage": 0,
  "currency": "IRR"
}
```

### اعمال تخفیف
**درخواست:** `POST /api/v1/prices/{price}/discount`

**بدنه درخواست:**
```json
{
  "discount_percentage": 15,
  "discount_start": "2024-04-20",
  "discount_end": "2024-04-30"
}
```

**پاسخ:**
```json
{
  "success": true,
  "message": "تخفیف اعمال شد",
  "data": {
    "original_price": 150000,
    "discount_percentage": 15,
    "discounted_price": 127500,
    "savings": 22500
  }
}
```

### دریافت تاریخچه قیمت
**درخواست:** `GET /api/v1/prices/product/{productId}/history`

**پارامترهای کوئری:**
- `start_date` (optional): تاریخ شروع
- `end_date` (optional): تاریخ پایان

### آمار قیمت‌گذاری
**درخواست:** `GET /api/v1/prices/analytics`

**پاسخ:**
```json
{
  "success": true,
  "message": "آمار قیمت‌گذاری",
  "data": {
    "total_price_changes": 156,
    "price_increases": 89,
    "price_decreases": 67,
    "average_profit_margin": 45.5
  }
}
```

---

## مدیریت انقضا (Batches & Expiration)

### دریافت لیست دسته‌ها
**درخواست:** `GET /api/v1/batches`

**پارامترهای کوئری:**
- `status` (optional): وضعیت (active, expired, recalled, disposed)
- `warehouse_id` (optional): فیلتر بر اساس انبار
- `expiring_soon` (optional): فقط دسته‌های به‌زودی منقضی (true/false)

### دریافت دسته‌های منقضی‌شده
**درخواست:** `GET /api/v1/batches/expired`

**پاسخ:**
```json
{
  "success": true,
  "message": "دسته‌های منقضی دریافت‌شده",
  "count": 12,
  "data": [...]
}
```

### دریافت دسته‌های به‌زودی منقضی
**درخواست:** `GET /api/v1/batches/expiring-soon`

**پارامترهای کوئری:**
- `days` (optional): تعداد روز (پیش‌فرض: 30)

### ایجاد دسته جدید
**درخواست:** `POST /api/v1/batches`

**بدنه درخواست:**
```json
{
  "product_id": 101,
  "batch_number": "BATCH-2024-001-A",
  "warehouse_id": 1,
  "quantity": 500,
  "manufacturing_date": "2024-03-01",
  "expiration_date": "2025-03-01"
}
```

### دریافت هشدارهای انقضا
**درخواست:** `GET /api/v1/batches/alerts`

**پارامترهای کوئری:**
- `level` (optional): سطح هشدار (warning, critical, expired)
- `unacknowledged` (optional): فقط هشدارهای تایید‌نشده

**پاسخ:**
```json
{
  "success": true,
  "message": "هشدارهای انقضا دریافت‌شده",
  "data": [...],
  "summary": {
    "total": 45,
    "warning": 20,
    "critical": 15,
    "expired": 10,
    "unacknowledged": 25
  }
}
```

### تایید هشدار
**درخواست:** `PUT /api/v1/batches/alerts/{alert}/acknowledge`

### ثبت اقدام برای هشدار
**درخواست:** `POST /api/v1/batches/alerts/{alert}/action`

**بدنه درخواست:**
```json
{
  "action": "دفع کردن محصول - فسخ شده توسط تهیه‌کننده"
}
```

### گزارش انقضا
**درخواست:** `GET /api/v1/batches/report`

**پاسخ:**
```json
{
  "success": true,
  "message": "گزارش انقضا",
  "data": {
    "total_batches": 150,
    "expired_batches": 12,
    "expiring_30_days": 25,
    "expiring_7_days": 8,
    "active_alerts": 30,
    "critical_alerts": 5
  }
}
```

---

## مدیریت انبار (Warehouses)

### دریافت لیست انبارها
**درخواست:** `GET /api/v1/warehouses`

### ایجاد انبار جدید
**درخواست:** `POST /api/v1/warehouses`

**بدنه درخواست:**
```json
{
  "name": "انبار دزفول",
  "location": "خیابان توحید",
  "capacity": 1000,
  "manager_name": "مهرداد",
  "phone": "09166809066"
}
```

---

## انتقال موجودی (Transfers)

### دریافت لیست انتقال‌ها
**درخواست:** `GET /api/v1/transfers`

### ایجاد انتقال جدید
**درخواست:** `POST /api/v1/transfers`

**بدنه درخواست:**
```json
{
  "product_id": 101,
  "source_warehouse_id": 1,
  "destination_warehouse_id": 2,
  "quantity": 100
}
```

### ارسال انتقال
**درخواست:** `POST /api/v1/transfers/{transfer}/ship`

### دریافت انتقال
**درخواست:** `POST /api/v1/transfers/{transfer}/receive`

### لغو انتقال
**درخواست:** `POST /api/v1/transfers/{transfer}/cancel`

---

## گزارش‌ها (Reports)

### خلاصه موجودی
**درخواست:** `GET /api/v1/reports/inventory-summary`

### گزارش موجودی پایین
**درخواست:** `GET /api/v1/reports/low-stock-report`

### گزارش تغییرات قیمت
**درخواست:** `GET /api/v1/reports/price-changes`

### گزارش انقضا
**درخواست:** `GET /api/v1/reports/expiration-report`

### گزارش کارایی انبار
**درخواست:** `GET /api/v1/reports/warehouse-performance`

### وضعیت هماهنگی
**درخواست:** `GET /api/v1/reports/sync-status`

---

## کدهای وضعیت مشترک

- **200**: موفق - درخواست موفق‌آمیز
- **201**: ایجاد شد - منبع جدید ایجاد شد
- **400**: درخواست نامعتبر - خطا در ورودی
- **401**: غیرمجاز - لازم است احراز هویت انجام شود
- **403**: ممنوع - کاربر اجازه دسترسی ندارد
- **404**: یافت نشد - منبع درخواست‌شده وجود ندارد
- **422**: عدم پردازش - خطا در اعتبار‌سنجی
- **500**: خطای سرور - خطای داخلی سرور

---

## نکات مهم

1. **احراز هویت**: تمام درخواست‌ها (به جز ورود و ثبت‌نام) به توکن JWT نیاز دارند
2. **رفاه‌شناسی (Rate Limiting)**: حداکثر 100 درخواست در 1 دقیقه
3. **صفحه‌بندی**: پیش‌فرض 15 نتیجه در هر صفحه
4. **زمان منطقه‌ای**: تمام زمان‌ها به صورت ISO 8601 و فی UTC هستند

---

## مثال‌های cURL

### ورود
```bash
curl -X POST http://localhost:8000/api/v1/auth/login \
  -H "Content-Type: application/json" \
  -d '{"email":"user@dezkala.com","password":"password123"}'
```

### دریافت موجودی
```bash
curl -X GET http://localhost:8000/api/v1/inventory \
  -H "Authorization: Bearer YOUR_TOKEN"
```

### بروز کردن قیمت
```bash
curl -X PUT http://localhost:8000/api/v1/prices/1 \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"selling_price":150000,"reason":"تعدیل قیمت بازار"}'
```

---

**نسخه:** 1.0  
**آخرین بروزرسانی:** ۱۴۰۵/۱۰/۲۳
