# سیستم حسابداری و مدیریت موجودی - DezKala

## نمای کلی سیستم

سیستم حسابداری و مدیریت موجودی متصل به فروشگاه DezKala با توانایی‌های زیر:

### ویژگی‌های اصلی
- 📊 **مدیریت موجودی دوطرفه** - همگام‌سازی خودکار با فروشگاه اصلی
- 💰 **مدیریت قیمت‌ها** - تحدیث قیمت‌ها در زمان واقعی
- 📅 **ردیابی تاریخ انقضا** - هشدار خودکار برای محصولات منقضی‌شده
- 📈 **گزارش‌های جامع** - تحلیل موجودی و فروش
- 🔐 **سیستم امنیتی قوی** - کنترل دسترسی و رمزنگاری

## ساختار پروژه

```
ACCOUNTING_SYSTEM/
├── public/                    # فایل‌های عمومی
│   ├── index.php             # نقطه ورود
│   ├── css/
│   └── js/
├── app/
│   ├── Models/               # مدل‌های دیتابیس
│   ├── Controllers/          # کنترلرها
│   ├── Middleware/           # میدلویر‌ها
│   └── Services/             # سرویس‌های تجاری
├── config/                   # فایل‌های کانفیگ
├── database/
│   └── migrations/           # مایگریشن‌ها
├── routes/                   # تعریف مسیرها
├── storage/                  # پوشه ذخیره‌سازی
└── vendor/                   # وابستگی‌ها
```

## نیازمندی‌های سیستم

- PHP 8.1+
- MySQL 5.7+
- Composer
- Web Server (Apache/Nginx)

## نصب و راه‌اندازی

### 1. دانلود و استقرار
```bash
cd /home/dezkalac/public_html/acc
git clone [repository] .
composer install
```

### 2. تنظیم کانفیگ
```bash
cp .env.example .env
php artisan key:generate
```

### 3. ایجاد دیتابیس
```bash
php artisan migrate
php artisan db:seed
```

### 4. تنظیم مجوزها
```bash
chmod -R 775 storage/
chmod -R 775 bootstrap/cache/
```

## کانفیگ DNS

برای دسترسی از طریق `acc.dezkala.com`:

```
A Record: acc.dezkala.com → [Server IP]
```

## API Endpoints

### مدیریت موجودی

#### دریافت موجودی
```
GET /api/inventory/{productId}
Auth: Bearer {token}
```

**پاسخ:**
```json
{
  "product_id": 123,
  "name": "محصول نمونه",
  "quantity": 50,
  "reorder_level": 10,
  "last_updated": "2026-02-09",
  "warehouse": "warehouse_1"
}
```

#### به‌روز‌رسانی موجودی
```
POST /api/inventory/update
Auth: Bearer {token}

{
  "product_id": 123,
  "quantity": 45,
  "warehouse": "warehouse_1",
  "reason": "فروش",
  "notes": "سفارش #1234"
}
```

#### انتقال موجودی
```
POST /api/inventory/transfer
Auth: Bearer {token}

{
  "product_id": 123,
  "from_warehouse": "warehouse_1",
  "to_warehouse": "warehouse_2",
  "quantity": 10
}
```

### مدیریت قیمت‌ها

#### دریافت قیمت‌ها
```
GET /api/prices/{productId}
Auth: Bearer {token}
```

#### تحدیث قیمت
```
POST /api/prices/update
Auth: Bearer {token}

{
  "product_id": 123,
  "base_price": 100000,
  "selling_price": 120000,
  "wholesale_price": 95000,
  "discount": 10,
  "effective_date": "2026-02-10"
}
```

### مدیریت تاریخ انقضا

#### ثبت تاریخ انقضا
```
POST /api/expiration/set
Auth: Bearer {token}

{
  "product_id": 123,
  "batch_number": "BATCH-001",
  "expiration_date": "2026-12-31",
  "quantity": 50,
  "warehouse": "warehouse_1"
}
```

#### دریافت محصولات در حال انقضا
```
GET /api/expiration/alerts?days=30
Auth: Bearer {token}
```

## کنترل دسترسی

### سطح‌های دسترسی
- **مدیر سیستم** - دسترسی کامل
- **مدیر انبار** - مدیریت موجودی و انبار
- **مدیر فروش** - مشاهده و مدیریت قیمت‌ها
- **گزارش‌گر** - نمایش گزارش‌ها و آمار

## گزارش‌های دستیاب

1. **گزارش موجودی** - وضعیت فعلی موجودی
2. **گزارش فروش** - آمار فروش روزانه/ماهانه
3. **گزارش تاریخ انقضا** - محصولات در شرف انقضا
4. **گزارش حرکت موجودی** - تاریخ تغییرات موجودی
5. **گزارش مالی** - ارزیابی موجودی

## امنیت

### رمزنگاری
- تمام ارتباطات از طریق HTTPS
- رمزنگاری پایگاه داده برای اطلاعات حساس

### احراز هویت
- JWT Token Authentication
- Two-Factor Authentication فراهم است

### مجوزها
- Hash رمزهای عبور
- Rate Limiting برای API
- CORS Configuration

## Support و پشتیبانی

برای مشاهده مستندات کاملتر:
- Documentation: `/docs`
- API Docs: `/api/docs`
- Contact: support@dezkala.com

## لایسنس

تمام حقوق برای DezKala محفوظ است.
